/*
 * Decompiled with CFR 0.152.
 */
package com.frcteam3255.components;

import edu.wpi.first.networktables.NetworkTable;
import edu.wpi.first.networktables.NetworkTableInstance;

public class SN_Limelight {
    NetworkTable table = NetworkTableInstance.getDefault().getTable("limelight");

    public boolean hasTarget() {
        return this.table.getEntry("tv").getDouble(0.0) > 0.0;
    }

    public double getOffsetX() {
        return this.table.getEntry("tx").getDouble(0.0);
    }

    public double getOffsetY() {
        return this.table.getEntry("ty").getDouble(0.0);
    }

    public double getTargetArea() {
        return this.table.getEntry("ta").getDouble(0.0);
    }

    private double getLEDModeFromEnum(LEDMode a_LEDMode) {
        switch (a_LEDMode) {
            case pipeline: {
                return 0.0;
            }
            case off: {
                return 1.0;
            }
            case blink: {
                return 2.0;
            }
            case on: {
                return 3.0;
            }
        }
        return 0.0;
    }

    public void setLEDMode(LEDMode a_LEDMode) {
        double b_LEDMode = this.getLEDModeFromEnum(a_LEDMode);
        this.table.getEntry("ledMode").setDouble(b_LEDMode);
    }

    public LEDMode getLEDMode() {
        switch ((int)this.table.getEntry("ledMode").getDouble(0.0)) {
            case 0: {
                return LEDMode.pipeline;
            }
            case 1: {
                return LEDMode.off;
            }
            case 2: {
                return LEDMode.blink;
            }
            case 3: {
                return LEDMode.on;
            }
        }
        return LEDMode.pipeline;
    }

    public void toggleLEDs() {
        if (this.getLEDMode() == LEDMode.off) {
            this.setLEDMode(LEDMode.on);
        } else {
            this.setLEDMode(LEDMode.off);
        }
    }

    public void setVideoFeedProcessed() {
        this.table.getEntry("camMode").setDouble(0.0);
    }

    public void setVideoFeedNoProcessing() {
        this.table.getEntry("camMode").setDouble(1.0);
    }

    public void setPipeline(int a_pipeline) {
        this.table.getEntry("pipeline").setDouble((double)a_pipeline);
    }

    public static enum LEDMode {
        pipeline,
        off,
        blink,
        on;

    }
}

