/*
 * Decompiled with CFR 0.152.
 */
package com.frcteam3255.components.swerve;

import com.ctre.phoenix6.configs.CANcoderConfiguration;
import com.ctre.phoenix6.configs.TalonFXConfiguration;
import com.ctre.phoenix6.hardware.Pigeon2;
import com.frcteam3255.components.swerve.SN_SwerveConstants;
import com.frcteam3255.components.swerve.SN_SwerveModule;
import com.pathplanner.lib.auto.AutoBuilder;
import com.pathplanner.lib.config.PIDConstants;
import com.pathplanner.lib.config.RobotConfig;
import com.pathplanner.lib.controllers.PPHolonomicDriveController;
import com.pathplanner.lib.controllers.PathFollowingController;
import com.pathplanner.lib.trajectory.PathPlannerTrajectory;
import edu.wpi.first.math.MathUtil;
import edu.wpi.first.math.Matrix;
import edu.wpi.first.math.controller.HolonomicDriveController;
import edu.wpi.first.math.estimator.SwerveDrivePoseEstimator;
import edu.wpi.first.math.geometry.Pose2d;
import edu.wpi.first.math.geometry.Rotation2d;
import edu.wpi.first.math.geometry.Translation2d;
import edu.wpi.first.math.kinematics.ChassisSpeeds;
import edu.wpi.first.math.kinematics.SwerveDriveKinematics;
import edu.wpi.first.math.kinematics.SwerveModulePosition;
import edu.wpi.first.math.kinematics.SwerveModuleState;
import edu.wpi.first.math.numbers.N1;
import edu.wpi.first.math.numbers.N3;
import edu.wpi.first.units.Measure;
import edu.wpi.first.units.Units;
import edu.wpi.first.units.measure.Angle;
import edu.wpi.first.units.measure.AngularVelocity;
import edu.wpi.first.units.measure.Distance;
import edu.wpi.first.units.measure.LinearVelocity;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.smartdashboard.Field2d;
import edu.wpi.first.wpilibj2.command.Command;
import edu.wpi.first.wpilibj2.command.Subsystem;
import edu.wpi.first.wpilibj2.command.SubsystemBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;

public class SN_SuperSwerve
extends SubsystemBase {
    public SN_SwerveModule[] modules;
    public SwerveDrivePoseEstimator swervePoseEstimator;
    public SwerveDriveKinematics swerveKinematics;
    public Pigeon2 pigeon;
    public boolean isFieldRelative = true;
    public SN_SwerveConstants swerveConstants;
    public PIDConstants autoDrivePID;
    public PIDConstants autoSteerPID;
    private Matrix<N3, N1> stateStdDevs;
    private Matrix<N3, N1> visionStdDevs;
    public HashMap<String, Command> autoEventMap = new HashMap();
    public BooleanSupplier autoFlipPaths;
    public PathPlannerTrajectory exampleAuto;
    private boolean isSimulation;
    public double simAngle = 0.0;
    private SwerveModuleState[] lastDesiredStates = new SwerveModuleState[]{new SwerveModuleState(), new SwerveModuleState(), new SwerveModuleState(), new SwerveModuleState()};
    public double timeFromLastUpdate = 0.0;
    public double lastSimTime = Timer.getFPGATimestamp();
    public Field2d field = new Field2d();
    public TalonFXConfiguration driveConfig;
    public TalonFXConfiguration steerConfig;
    public CANcoderConfiguration cancoderConfig;
    public HolonomicDriveController teleopAutoDriveController;
    public AngularVelocity turnSpeed;

    public SN_SuperSwerve(SN_SwerveConstants swerveConstants, SN_SwerveModule[] modules, double wheelbase, double trackWidth, String CANBusName, int pigeonCANId, double minimumSteerPercent, TalonFXConfiguration driveConfig, TalonFXConfiguration steerConfig, CANcoderConfiguration cancoderConfig, Matrix<N3, N1> stateStdDevs, Matrix<N3, N1> visionStdDevs, PIDConstants autoDrivePID, PIDConstants autoSteerPID, HolonomicDriveController teleopAutoDriveController, AngularVelocity turnSpeed, RobotConfig robotConfig, BooleanSupplier autoFlipPaths, boolean isSimulation) {
        this.swerveKinematics = new SwerveDriveKinematics(new Translation2d[]{new Translation2d(wheelbase / 2.0, trackWidth / 2.0), new Translation2d(wheelbase / 2.0, -trackWidth / 2.0), new Translation2d(-wheelbase / 2.0, trackWidth / 2.0), new Translation2d(-wheelbase / 2.0, -trackWidth / 2.0)});
        this.modules = modules;
        this.stateStdDevs = stateStdDevs;
        this.visionStdDevs = visionStdDevs;
        this.swerveConstants = swerveConstants;
        this.autoDrivePID = autoDrivePID;
        this.autoSteerPID = autoSteerPID;
        this.isSimulation = isSimulation;
        this.autoFlipPaths = autoFlipPaths;
        this.teleopAutoDriveController = teleopAutoDriveController;
        this.turnSpeed = turnSpeed;
        this.driveConfig = driveConfig;
        this.steerConfig = steerConfig;
        this.cancoderConfig = cancoderConfig;
        SN_SwerveModule.isSimulation = isSimulation;
        SN_SwerveModule.wheelCircumference = swerveConstants.wheelCircumference;
        SN_SwerveModule.maxModuleSpeedMeters = swerveConstants.maxSpeedMeters;
        SN_SwerveModule.minimumSteerSpeedPercent = minimumSteerPercent;
        this.pigeon = new Pigeon2(pigeonCANId, CANBusName);
        Timer.delay((double)2.5);
        this.resetModulesToAbsolute();
        this.configure();
        AutoBuilder.configure(this::getPose, this::resetPoseToPose, this::getChassisSpeeds, this::driveAutonomous, (PathFollowingController)new PPHolonomicDriveController(autoDrivePID, autoSteerPID), (RobotConfig)robotConfig, (BooleanSupplier)autoFlipPaths, (Subsystem[])new Subsystem[]{this});
    }

    public void configure() {
        SN_SwerveModule.driveConfiguration = this.driveConfig;
        SN_SwerveModule.steerConfiguration = this.steerConfig;
        SN_SwerveModule.cancoderConfiguration = this.cancoderConfig;
        for (SN_SwerveModule mod : this.modules) {
            mod.configure();
        }
        this.swervePoseEstimator = new SwerveDrivePoseEstimator(this.swerveKinematics, this.getGyroRotation(), this.getModulePositions(), new Pose2d(), this.stateStdDevs, this.visionStdDevs);
    }

    public void resetModulesToAbsolute() {
        for (SN_SwerveModule mod : this.modules) {
            mod.resetSteerMotorToAbsolute();
        }
    }

    public SwerveModulePosition[] getModulePositions() {
        SwerveModulePosition[] positions = new SwerveModulePosition[4];
        for (SN_SwerveModule mod : this.modules) {
            positions[mod.moduleNumber] = mod.getModulePosition();
        }
        return positions;
    }

    public SwerveModuleState[] getActualModuleStates() {
        SwerveModuleState[] states = new SwerveModuleState[4];
        for (SN_SwerveModule mod : this.modules) {
            states[mod.moduleNumber] = mod.getActualModuleState();
        }
        return states;
    }

    public SwerveModuleState[] getDesiredModuleStates() {
        SwerveModuleState[] states = new SwerveModuleState[4];
        for (SN_SwerveModule mod : this.modules) {
            states[mod.moduleNumber] = mod.getDesiredModuleState();
        }
        return this.lastDesiredStates;
    }

    public ChassisSpeeds getChassisSpeeds() {
        return this.swerveKinematics.toChassisSpeeds(this.getActualModuleStates());
    }

    public void setModuleStates(SwerveModuleState[] desiredModuleStates, boolean isOpenLoop) {
        SwerveDriveKinematics.desaturateWheelSpeeds((SwerveModuleState[])desiredModuleStates, (double)this.swerveConstants.maxSpeedMeters);
        this.lastDesiredStates = desiredModuleStates;
        for (SN_SwerveModule mod : this.modules) {
            mod.setModuleState(desiredModuleStates[mod.moduleNumber], isOpenLoop, false);
        }
    }

    public void drive(Translation2d translation, double rotation, boolean isOpenLoop) {
        ChassisSpeeds chassisSpeeds = this.isFieldRelative ? ChassisSpeeds.fromFieldRelativeSpeeds((double)translation.getX(), (double)translation.getY(), (double)rotation, (Rotation2d)this.getRotation()) : new ChassisSpeeds(translation.getX(), translation.getY(), rotation);
        SwerveModuleState[] desiredModuleStates = this.swerveKinematics.toSwerveModuleStates(ChassisSpeeds.discretize((ChassisSpeeds)chassisSpeeds, (double)this.timeFromLastUpdate));
        this.setModuleStates(desiredModuleStates, isOpenLoop);
    }

    public void drive(ChassisSpeeds chassisSpeeds, boolean isOpenLoop) {
        SwerveModuleState[] desiredModuleStates = this.swerveKinematics.toSwerveModuleStates(ChassisSpeeds.discretize((ChassisSpeeds)chassisSpeeds, (double)this.timeFromLastUpdate));
        this.setModuleStates(desiredModuleStates, isOpenLoop);
    }

    public void driveAutonomous(ChassisSpeeds chassisSpeeds) {
        this.drive(chassisSpeeds, false);
    }

    public void neutralDriveOutputs() {
        for (SN_SwerveModule mod : this.modules) {
            mod.neutralDriveOutput();
        }
    }

    public void setFieldRelative() {
        this.isFieldRelative = true;
    }

    public void setRobotRelative() {
        this.isFieldRelative = false;
    }

    public void updatePoseEstimator() {
        this.swervePoseEstimator.updateWithTime(Timer.getFPGATimestamp(), this.getGyroRotation(), this.getModulePositions());
    }

    public Pose2d getPose() {
        return this.swervePoseEstimator.getEstimatedPosition();
    }

    public Rotation2d getRotation() {
        return this.swervePoseEstimator.getEstimatedPosition().getRotation();
    }

    public void resetPoseToPose(Pose2d pose) {
        this.swervePoseEstimator.resetPosition(this.getGyroRotation(), (Object)this.getModulePositions(), pose);
    }

    private Rotation2d getGyroRotation() {
        if (this.isSimulation && this.lastDesiredStates != null) {
            this.simAngle += this.swerveKinematics.toChassisSpeeds((SwerveModuleState[])this.lastDesiredStates).omegaRadiansPerSecond * this.timeFromLastUpdate;
            this.simAngle %= Math.PI * 2;
            this.simAngle = this.simAngle < 0.0 ? this.simAngle + Math.PI * 2 : this.simAngle;
            return Rotation2d.fromRadians((double)this.simAngle);
        }
        double yaw = this.pigeon.getYaw().getValueAsDouble() % 360.0;
        return yaw < 0.0 ? Rotation2d.fromDegrees((double)(yaw + 360.0)) : Rotation2d.fromDegrees((double)yaw);
    }

    public double getGyroRate() {
        return this.pigeon.getAngularVelocityZWorld().getValueAsDouble();
    }

    private void resetYaw(double yaw) {
        if (this.isSimulation) {
            this.simAngle = Units.Radians.convertFrom(yaw, Units.Degrees);
        }
        this.pigeon.setYaw(yaw);
    }

    public void addVisionMeasurement(Pose2d estimatedPose, double timestamp) {
        this.swervePoseEstimator.addVisionMeasurement(estimatedPose, timestamp);
    }

    public void updateTimer() {
        this.timeFromLastUpdate = Timer.getFPGATimestamp() - this.lastSimTime;
        this.lastSimTime = Timer.getFPGATimestamp();
    }

    public AngularVelocity getVelocityToRotate(Rotation2d desiredYaw) {
        double yawSetpoint = this.teleopAutoDriveController.getThetaController().calculate(this.getRotation().getRadians(), desiredYaw.getRadians());
        yawSetpoint = MathUtil.clamp((double)yawSetpoint, (double)(-this.turnSpeed.in(Units.RadiansPerSecond)), (double)this.turnSpeed.in(Units.RadiansPerSecond));
        return Units.RadiansPerSecond.of(yawSetpoint);
    }

    public void rotationalAlign(Pose2d desiredTarget, ChassisSpeeds velocities, boolean isOpenLoop) {
        this.drive(new Translation2d(velocities.vxMetersPerSecond, velocities.vyMetersPerSecond), this.getVelocityToRotate(desiredTarget.getRotation()).in(Units.RadiansPerSecond), isOpenLoop);
    }

    public void autoAlign(Pose2d desiredTarget, ChassisSpeeds manualVelocities, boolean isOpenLoop, boolean lockX, boolean lockY, boolean invertRotation) {
        ChassisSpeeds automatedDTVelocity = this.teleopAutoDriveController.calculate(this.getPose(), desiredTarget, 0.0, desiredTarget.getRotation());
        if (lockX) {
            automatedDTVelocity.vxMetersPerSecond = manualVelocities.vxMetersPerSecond;
        }
        if (lockY) {
            automatedDTVelocity.vyMetersPerSecond = manualVelocities.vyMetersPerSecond;
        }
        if (invertRotation) {
            automatedDTVelocity.omegaRadiansPerSecond = -automatedDTVelocity.omegaRadiansPerSecond;
        }
        this.drive(automatedDTVelocity, isOpenLoop);
    }

    public boolean isAtRotation(Rotation2d desiredRotation, Angle tolerance) {
        return this.getRotation().getMeasure().compareTo((Measure)desiredRotation.getMeasure().minus((Measure)tolerance)) > 0 && this.getRotation().getMeasure().compareTo((Measure)desiredRotation.getMeasure().plus((Measure)tolerance)) < 0;
    }

    public boolean isAtPosition(Pose2d desiredPose2d, Distance tolerance) {
        return Units.Meters.of(this.getPose().getTranslation().getDistance(desiredPose2d.getTranslation())).lte((Measure)tolerance);
    }

    public Pose2d getClosestPoseByRotation(List<Pose2d> poses) {
        Pose2d closestPose = poses.get(0);
        double smallestDifference = Math.abs(this.getRotation().minus(closestPose.getRotation()).getRadians());
        for (Pose2d pose : poses) {
            double difference = Math.abs(this.getRotation().minus(pose.getRotation()).getRadians());
            if (!(difference < smallestDifference)) continue;
            smallestDifference = difference;
            closestPose = pose;
        }
        return closestPose;
    }

    public ChassisSpeeds calculateVelocitiesFromInput(DoubleSupplier xAxisSupplier, DoubleSupplier yAxisSupplier, DoubleSupplier rotationAxisSupplier, BooleanSupplier slowMode, boolean isRed, double SLOW_MODE_MULTIPLIER, LinearVelocity REAL_DRIVE_SPEED, AngularVelocity TURN_SPEED) {
        double redAllianceMultiplier = isRed ? -1.0 : 1.0;
        double slowModeMultiplier = slowMode.getAsBoolean() ? SLOW_MODE_MULTIPLIER : 1.0;
        double xVelocity = xAxisSupplier.getAsDouble() * REAL_DRIVE_SPEED.in(Units.MetersPerSecond) * redAllianceMultiplier * slowModeMultiplier;
        double yVelocity = -yAxisSupplier.getAsDouble() * REAL_DRIVE_SPEED.in(Units.MetersPerSecond) * redAllianceMultiplier * slowModeMultiplier;
        double rotationVelocity = rotationAxisSupplier.getAsDouble() * TURN_SPEED.in(Units.RadiansPerSecond);
        return new ChassisSpeeds(xVelocity, yVelocity, rotationVelocity);
    }

    public void periodic() {
        this.updateTimer();
        this.updatePoseEstimator();
    }
}

