/*
 * Decompiled with CFR 0.152.
 */
package com.frcteam3255.components.swerve;

import com.ctre.phoenix6.configs.CANcoderConfiguration;
import com.ctre.phoenix6.configs.TalonFXConfiguration;
import com.ctre.phoenix6.controls.DutyCycleOut;
import com.ctre.phoenix6.controls.NeutralOut;
import com.ctre.phoenix6.controls.PositionVoltage;
import com.ctre.phoenix6.controls.VelocityDutyCycle;
import com.ctre.phoenix6.hardware.CANcoder;
import com.ctre.phoenix6.hardware.TalonFX;
import com.frcteam3255.components.swerve.SN_SwerveConstants;
import com.frcteam3255.utils.SN_Math;
import edu.wpi.first.math.geometry.Rotation2d;
import edu.wpi.first.math.kinematics.SwerveModulePosition;
import edu.wpi.first.math.kinematics.SwerveModuleState;
import edu.wpi.first.math.util.Units;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj2.command.SubsystemBase;

public class SN_SwerveModule
extends SubsystemBase {
    public TalonFX driveMotor;
    public TalonFX steerMotor;
    private CANcoder absoluteEncoder;
    private double absoluteEncoderOffset;
    public int moduleNumber;
    public static TalonFXConfiguration driveConfiguration = new TalonFXConfiguration();
    public static TalonFXConfiguration steerConfiguration = new TalonFXConfiguration();
    public static CANcoderConfiguration cancoderConfiguration;
    private DutyCycleOut driveMotorControllerOpen;
    private VelocityDutyCycle driveMotorControllerClosed;
    private PositionVoltage steerMotorController;
    public static double minimumSteerSpeedPercent;
    public static double wheelCircumference;
    public static double maxModuleSpeedMeters;
    public static boolean isSimulation;
    private SwerveModuleState lastDesiredSwerveModuleState = new SwerveModuleState(0.0, new Rotation2d(0.0));
    private double desiredDrivePosition;
    private double timeFromLastUpdate = 0.0;
    private Timer simTimer = new Timer();
    private double lastSimTime = this.simTimer.get();

    public SN_SwerveModule(int moduleNumber, int driveMotorID, int steerMotorID, int absoluteEncoderID, double absoluteEncoderOffset, String CANBusName) {
        this.simTimer.start();
        this.moduleNumber = moduleNumber;
        this.driveMotor = new TalonFX(driveMotorID, CANBusName);
        this.steerMotor = new TalonFX(steerMotorID, CANBusName);
        this.driveMotorControllerClosed = new VelocityDutyCycle(0.0);
        this.driveMotorControllerOpen = new DutyCycleOut(0.0);
        this.steerMotorController = new PositionVoltage(0.0);
        this.absoluteEncoder = new CANcoder(absoluteEncoderID, CANBusName);
        this.absoluteEncoderOffset = absoluteEncoderOffset;
        driveConfiguration = new TalonFXConfiguration();
        steerConfiguration = new TalonFXConfiguration();
        cancoderConfiguration = new CANcoderConfiguration();
    }

    public void configure() {
        this.driveMotor.getConfigurator().apply(driveConfiguration);
        this.steerMotor.getConfigurator().apply(steerConfiguration);
        this.absoluteEncoder.getConfigurator().apply(cancoderConfiguration);
    }

    public double getRawAbsoluteEncoder() {
        return this.absoluteEncoder.getAbsolutePosition().getValueAsDouble();
    }

    public double getAbsoluteEncoder() {
        double rotations = this.getRawAbsoluteEncoder();
        return rotations -= this.absoluteEncoderOffset;
    }

    public void resetSteerMotorToAbsolute() {
        this.steerMotor.setPosition(this.getAbsoluteEncoder());
    }

    public void resetDriveMotorEncoder() {
        this.driveMotor.setPosition(0.0);
    }

    public SwerveModuleState getActualModuleState() {
        double velocity = SN_Math.rotationsToMeters(this.driveMotor.getVelocity().getValueAsDouble(), wheelCircumference, 1.0);
        Rotation2d angle = Rotation2d.fromDegrees((double)Units.rotationsToDegrees((double)this.steerMotor.getPosition().getValueAsDouble()));
        return new SwerveModuleState(velocity, angle);
    }

    public SwerveModuleState getDesiredModuleState() {
        return this.lastDesiredSwerveModuleState;
    }

    public SwerveModulePosition getModulePosition() {
        if (isSimulation) {
            this.timeFromLastUpdate = this.simTimer.get() - this.lastSimTime;
            this.lastSimTime = this.simTimer.get();
            this.desiredDrivePosition += this.lastDesiredSwerveModuleState.speedMetersPerSecond * this.timeFromLastUpdate;
            return new SwerveModulePosition(this.desiredDrivePosition, this.lastDesiredSwerveModuleState.angle);
        }
        double distance = SN_Math.rotationsToMeters(this.driveMotor.getPosition().getValueAsDouble(), wheelCircumference, 1.0);
        Rotation2d angle = Rotation2d.fromDegrees((double)Units.rotationsToDegrees((double)this.steerMotor.getPosition().getValueAsDouble()));
        return new SwerveModulePosition(distance, angle);
    }

    public void neutralDriveOutput() {
        this.driveMotor.setControl(new NeutralOut());
    }

    public void setModuleState(SwerveModuleState desiredState, boolean isOpenLoop, boolean steerInPlace) {
        this.lastDesiredSwerveModuleState = desiredState;
        if (isOpenLoop) {
            this.driveMotorControllerOpen.Output = desiredState.speedMetersPerSecond / maxModuleSpeedMeters;
            this.driveMotor.setControl(this.driveMotorControllerOpen);
        } else {
            this.driveMotorControllerClosed.Velocity = SN_Math.metersToRotations(desiredState.speedMetersPerSecond, wheelCircumference, 1.0);
            this.driveMotor.setControl(this.driveMotorControllerClosed);
        }
        double rotation = desiredState.angle.getRotations();
        if (Math.abs(desiredState.speedMetersPerSecond) < minimumSteerSpeedPercent * maxModuleSpeedMeters && !steerInPlace) {
            return;
        }
        this.steerMotorController.Position = rotation;
        this.steerMotor.setControl(this.steerMotorController);
    }

    static {
        minimumSteerSpeedPercent = 0.01;
        wheelCircumference = SN_SwerveConstants.MK4I.FALCON.L2.wheelCircumference;
        maxModuleSpeedMeters = SN_SwerveConstants.MK4I.FALCON.L2.maxSpeedMeters;
        isSimulation = false;
    }
}

