/*
 * Decompiled with CFR 0.152.
 */
package com.frcteam3255.joystick;

import edu.wpi.first.math.MathUtil;
import edu.wpi.first.wpilibj.XboxController;
import edu.wpi.first.wpilibj2.command.button.Trigger;
import java.util.function.DoubleSupplier;

public class SN_XboxController
extends XboxController {
    public Trigger btn_A = new Trigger(() -> super.getAButton());
    public Trigger btn_B = new Trigger(() -> super.getBButton());
    public Trigger btn_X = new Trigger(() -> super.getXButton());
    public Trigger btn_Y = new Trigger(() -> super.getYButton());
    public Trigger btn_LeftBumper = new Trigger(() -> super.getLeftBumperButton());
    public Trigger btn_RightBumper = new Trigger(() -> super.getRightBumperButton());
    public Trigger btn_Start = new Trigger(() -> super.getStartButton());
    public Trigger btn_Back = new Trigger(() -> super.getBackButton());
    public Trigger btn_LeftStick = new Trigger(() -> super.getLeftStickButton());
    public Trigger btn_RightStick = new Trigger(() -> super.getRightStickButton());
    private final int D_PAD_NORTH = 0;
    private final int D_PAD_NORTH_EAST = 45;
    private final int D_PAD_EAST = 90;
    private final int D_PAD_SOUTH_EAST = 135;
    private final int D_PAD_SOUTH = 180;
    private final int D_PAD_SOUTH_WEST = 225;
    private final int D_PAD_WEST = 270;
    private final int D_PAD_NORTH_WEST = 315;
    public Trigger btn_North = new Trigger(() -> super.getPOV() == 0);
    public Trigger btn_NorthEast = new Trigger(() -> super.getPOV() == 45);
    public Trigger btn_East = new Trigger(() -> super.getPOV() == 90);
    public Trigger btn_SouthEast = new Trigger(() -> super.getPOV() == 135);
    public Trigger btn_South = new Trigger(() -> super.getPOV() == 180);
    public Trigger btn_SouthWest = new Trigger(() -> super.getPOV() == 225);
    public Trigger btn_West = new Trigger(() -> super.getPOV() == 270);
    public Trigger btn_NorthWest = new Trigger(() -> super.getPOV() == 315);
    private double TRIGGER_PRESS_THRESHOLD = 0.5;
    public Trigger btn_LeftTrigger = new Trigger(() -> super.getLeftTriggerAxis() > this.TRIGGER_PRESS_THRESHOLD);
    public Trigger btn_RightTrigger = new Trigger(() -> super.getRightTriggerAxis() > this.TRIGGER_PRESS_THRESHOLD);
    private double LEFT_DEADBAND = 0.1;
    private double RIGHT_DEADBAND = 0.1;
    public DoubleSupplier axis_LeftX = () -> MathUtil.applyDeadband((double)super.getLeftX(), (double)this.LEFT_DEADBAND);
    public DoubleSupplier axis_LeftY = () -> MathUtil.applyDeadband((double)(-super.getLeftY()), (double)this.LEFT_DEADBAND);
    public DoubleSupplier axis_RightX = () -> MathUtil.applyDeadband((double)super.getRightX(), (double)this.RIGHT_DEADBAND);
    public DoubleSupplier axis_RightY = () -> MathUtil.applyDeadband((double)(-super.getRightY()), (double)this.RIGHT_DEADBAND);
    public DoubleSupplier axis_LeftTrigger = () -> super.getLeftTriggerAxis();
    public DoubleSupplier axis_RightTrigger = () -> super.getRightTriggerAxis();

    public void setTriggerPressThreshold(double threshold) {
        this.TRIGGER_PRESS_THRESHOLD = MathUtil.clamp((double)threshold, (double)0.0, (double)0.99);
    }

    public void setLeftDeadband(double deadband) {
        this.LEFT_DEADBAND = deadband;
    }

    public void setRightDeadband(double deadband) {
        this.RIGHT_DEADBAND = deadband;
    }

    public SN_XboxController(int port, double leftDeadband, double rightDeadband) {
        super(port);
        this.LEFT_DEADBAND = leftDeadband;
        this.RIGHT_DEADBAND = rightDeadband;
    }

    public SN_XboxController(int port) {
        super(port);
    }
}

