/*
 * Decompiled with CFR 0.152.
 */
package com.frcteam3255.utils;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.wpi.first.math.geometry.Pose2d;
import edu.wpi.first.math.geometry.Pose3d;
import edu.wpi.first.math.geometry.Rotation2d;
import edu.wpi.first.math.geometry.Rotation3d;
import edu.wpi.first.math.geometry.Translation2d;
import edu.wpi.first.math.geometry.Translation3d;
import edu.wpi.first.math.util.Units;
import edu.wpi.first.networktables.DoubleArrayEntry;
import edu.wpi.first.networktables.NetworkTable;
import edu.wpi.first.networktables.NetworkTableEntry;
import edu.wpi.first.networktables.NetworkTableInstance;
import edu.wpi.first.networktables.PubSubOption;
import edu.wpi.first.networktables.TimestampedDoubleArray;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class LimelightHelpers {
    private static final Map<String, DoubleArrayEntry> doubleArrayEntries = new ConcurrentHashMap<String, DoubleArrayEntry>();
    private static ObjectMapper mapper;
    static boolean profileJSON;

    static final String sanitizeName(String name) {
        if (name == "" || name == null) {
            return "limelight";
        }
        return name;
    }

    public static Pose3d toPose3D(double[] inData) {
        if (inData.length < 6) {
            return new Pose3d();
        }
        return new Pose3d(new Translation3d(inData[0], inData[1], inData[2]), new Rotation3d(Units.degreesToRadians((double)inData[3]), Units.degreesToRadians((double)inData[4]), Units.degreesToRadians((double)inData[5])));
    }

    public static Pose2d toPose2D(double[] inData) {
        if (inData.length < 6) {
            return new Pose2d();
        }
        Translation2d tran2d = new Translation2d(inData[0], inData[1]);
        Rotation2d r2d = new Rotation2d(Units.degreesToRadians((double)inData[5]));
        return new Pose2d(tran2d, r2d);
    }

    public static double[] pose3dToArray(Pose3d pose) {
        double[] result = new double[]{pose.getTranslation().getX(), pose.getTranslation().getY(), pose.getTranslation().getZ(), Units.radiansToDegrees((double)pose.getRotation().getX()), Units.radiansToDegrees((double)pose.getRotation().getY()), Units.radiansToDegrees((double)pose.getRotation().getZ())};
        return result;
    }

    public static double[] pose2dToArray(Pose2d pose) {
        double[] result = new double[]{pose.getTranslation().getX(), pose.getTranslation().getY(), 0.0, Units.radiansToDegrees((double)0.0), Units.radiansToDegrees((double)0.0), Units.radiansToDegrees((double)pose.getRotation().getRadians())};
        return result;
    }

    private static double extractArrayEntry(double[] inData, int position) {
        if (inData.length < position + 1) {
            return 0.0;
        }
        return inData[position];
    }

    private static PoseEstimate getBotPoseEstimate(String limelightName, String entryName) {
        DoubleArrayEntry poseEntry = LimelightHelpers.getLimelightDoubleArrayEntry(limelightName, entryName);
        TimestampedDoubleArray tsValue = poseEntry.getAtomic();
        double[] poseArray = tsValue.value;
        long timestamp = tsValue.timestamp;
        if (poseArray.length == 0) {
            return null;
        }
        Pose2d pose = LimelightHelpers.toPose2D(poseArray);
        double latency = LimelightHelpers.extractArrayEntry(poseArray, 6);
        int tagCount = (int)LimelightHelpers.extractArrayEntry(poseArray, 7);
        double tagSpan = LimelightHelpers.extractArrayEntry(poseArray, 8);
        double tagDist = LimelightHelpers.extractArrayEntry(poseArray, 9);
        double tagArea = LimelightHelpers.extractArrayEntry(poseArray, 10);
        double adjustedTimestamp = (double)timestamp / 1000000.0 - latency / 1000.0;
        RawFiducial[] rawFiducials = new RawFiducial[tagCount];
        int valsPerFiducial = 7;
        int expectedTotalVals = 11 + valsPerFiducial * tagCount;
        if (poseArray.length == expectedTotalVals) {
            for (int i = 0; i < tagCount; ++i) {
                int baseIndex = 11 + i * valsPerFiducial;
                int id = (int)poseArray[baseIndex];
                double txnc = poseArray[baseIndex + 1];
                double tync = poseArray[baseIndex + 2];
                double ta = poseArray[baseIndex + 3];
                double distToCamera = poseArray[baseIndex + 4];
                double distToRobot = poseArray[baseIndex + 5];
                double ambiguity = poseArray[baseIndex + 6];
                rawFiducials[i] = new RawFiducial(id, txnc, tync, ta, distToCamera, distToRobot, ambiguity);
            }
        }
        return new PoseEstimate(pose, adjustedTimestamp, latency, tagCount, tagSpan, tagDist, tagArea, rawFiducials);
    }

    private static RawFiducial[] getRawFiducials(String limelightName) {
        int valsPerEntry;
        NetworkTableEntry entry = LimelightHelpers.getLimelightNTTableEntry(limelightName, "rawfiducials");
        double[] rawFiducialArray = entry.getDoubleArray(new double[0]);
        if (rawFiducialArray.length % (valsPerEntry = 7) != 0) {
            return new RawFiducial[0];
        }
        int numFiducials = rawFiducialArray.length / valsPerEntry;
        RawFiducial[] rawFiducials = new RawFiducial[numFiducials];
        for (int i = 0; i < numFiducials; ++i) {
            int baseIndex = i * valsPerEntry;
            int id = (int)LimelightHelpers.extractArrayEntry(rawFiducialArray, baseIndex);
            double txnc = LimelightHelpers.extractArrayEntry(rawFiducialArray, baseIndex + 1);
            double tync = LimelightHelpers.extractArrayEntry(rawFiducialArray, baseIndex + 2);
            double ta = LimelightHelpers.extractArrayEntry(rawFiducialArray, baseIndex + 3);
            double distToCamera = LimelightHelpers.extractArrayEntry(rawFiducialArray, baseIndex + 4);
            double distToRobot = LimelightHelpers.extractArrayEntry(rawFiducialArray, baseIndex + 5);
            double ambiguity = LimelightHelpers.extractArrayEntry(rawFiducialArray, baseIndex + 6);
            rawFiducials[i] = new RawFiducial(id, txnc, tync, ta, distToCamera, distToRobot, ambiguity);
        }
        return rawFiducials;
    }

    public static RawDetection[] getRawDetections(String limelightName) {
        int valsPerEntry;
        NetworkTableEntry entry = LimelightHelpers.getLimelightNTTableEntry(limelightName, "rawdetections");
        double[] rawDetectionArray = entry.getDoubleArray(new double[0]);
        if (rawDetectionArray.length % (valsPerEntry = 11) != 0) {
            return new RawDetection[0];
        }
        int numDetections = rawDetectionArray.length / valsPerEntry;
        RawDetection[] rawDetections = new RawDetection[numDetections];
        for (int i = 0; i < numDetections; ++i) {
            int baseIndex = i * valsPerEntry;
            int classId = (int)LimelightHelpers.extractArrayEntry(rawDetectionArray, baseIndex);
            double txnc = LimelightHelpers.extractArrayEntry(rawDetectionArray, baseIndex + 1);
            double tync = LimelightHelpers.extractArrayEntry(rawDetectionArray, baseIndex + 2);
            double ta = LimelightHelpers.extractArrayEntry(rawDetectionArray, baseIndex + 3);
            double corner0_X = LimelightHelpers.extractArrayEntry(rawDetectionArray, baseIndex + 4);
            double corner0_Y = LimelightHelpers.extractArrayEntry(rawDetectionArray, baseIndex + 5);
            double corner1_X = LimelightHelpers.extractArrayEntry(rawDetectionArray, baseIndex + 6);
            double corner1_Y = LimelightHelpers.extractArrayEntry(rawDetectionArray, baseIndex + 7);
            double corner2_X = LimelightHelpers.extractArrayEntry(rawDetectionArray, baseIndex + 8);
            double corner2_Y = LimelightHelpers.extractArrayEntry(rawDetectionArray, baseIndex + 9);
            double corner3_X = LimelightHelpers.extractArrayEntry(rawDetectionArray, baseIndex + 10);
            double corner3_Y = LimelightHelpers.extractArrayEntry(rawDetectionArray, baseIndex + 11);
            rawDetections[i] = new RawDetection(classId, txnc, tync, ta, corner0_X, corner0_Y, corner1_X, corner1_Y, corner2_X, corner2_Y, corner3_X, corner3_Y);
        }
        return rawDetections;
    }

    public static void printPoseEstimate(PoseEstimate pose) {
        if (pose == null) {
            System.out.println("No PoseEstimate available.");
            return;
        }
        System.out.printf("Pose Estimate Information:%n", new Object[0]);
        System.out.printf("Timestamp (Seconds): %.3f%n", pose.timestampSeconds);
        System.out.printf("Latency: %.3f ms%n", pose.latency);
        System.out.printf("Tag Count: %d%n", pose.tagCount);
        System.out.printf("Tag Span: %.2f meters%n", pose.tagSpan);
        System.out.printf("Average Tag Distance: %.2f meters%n", pose.avgTagDist);
        System.out.printf("Average Tag Area: %.2f%% of image%n", pose.avgTagArea);
        System.out.println();
        if (pose.rawFiducials == null || pose.rawFiducials.length == 0) {
            System.out.println("No RawFiducials data available.");
            return;
        }
        System.out.println("Raw Fiducials Details:");
        for (int i = 0; i < pose.rawFiducials.length; ++i) {
            RawFiducial fiducial = pose.rawFiducials[i];
            System.out.printf(" Fiducial #%d:%n", i + 1);
            System.out.printf("  ID: %d%n", fiducial.id);
            System.out.printf("  TXNC: %.2f%n", fiducial.txnc);
            System.out.printf("  TYNC: %.2f%n", fiducial.tync);
            System.out.printf("  TA: %.2f%n", fiducial.ta);
            System.out.printf("  Distance to Camera: %.2f meters%n", fiducial.distToCamera);
            System.out.printf("  Distance to Robot: %.2f meters%n", fiducial.distToRobot);
            System.out.printf("  Ambiguity: %.2f%n", fiducial.ambiguity);
            System.out.println();
        }
    }

    public static NetworkTable getLimelightNTTable(String tableName) {
        return NetworkTableInstance.getDefault().getTable(LimelightHelpers.sanitizeName(tableName));
    }

    public static void Flush() {
        NetworkTableInstance.getDefault().flush();
    }

    public static NetworkTableEntry getLimelightNTTableEntry(String tableName, String entryName) {
        return LimelightHelpers.getLimelightNTTable(tableName).getEntry(entryName);
    }

    public static DoubleArrayEntry getLimelightDoubleArrayEntry(String tableName, String entryName) {
        String key = tableName + "/" + entryName;
        return doubleArrayEntries.computeIfAbsent(key, k -> {
            NetworkTable table = LimelightHelpers.getLimelightNTTable(tableName);
            return table.getDoubleArrayTopic(entryName).getEntry(new double[0], new PubSubOption[0]);
        });
    }

    public static double getLimelightNTDouble(String tableName, String entryName) {
        return LimelightHelpers.getLimelightNTTableEntry(tableName, entryName).getDouble(0.0);
    }

    public static void setLimelightNTDouble(String tableName, String entryName, double val) {
        LimelightHelpers.getLimelightNTTableEntry(tableName, entryName).setDouble(val);
    }

    public static void setLimelightNTDoubleArray(String tableName, String entryName, double[] val) {
        LimelightHelpers.getLimelightNTTableEntry(tableName, entryName).setDoubleArray(val);
    }

    public static double[] getLimelightNTDoubleArray(String tableName, String entryName) {
        return LimelightHelpers.getLimelightNTTableEntry(tableName, entryName).getDoubleArray(new double[0]);
    }

    public static String getLimelightNTString(String tableName, String entryName) {
        return LimelightHelpers.getLimelightNTTableEntry(tableName, entryName).getString("");
    }

    public static String[] getLimelightNTStringArray(String tableName, String entryName) {
        return LimelightHelpers.getLimelightNTTableEntry(tableName, entryName).getStringArray(new String[0]);
    }

    public static URL getLimelightURLString(String tableName, String request) {
        String urlString = "http://" + LimelightHelpers.sanitizeName(tableName) + ".local:5807/" + request;
        try {
            URL url = new URL(urlString);
            return url;
        }
        catch (MalformedURLException e) {
            System.err.println("bad LL URL");
            return null;
        }
    }

    public static double getTX(String limelightName) {
        return LimelightHelpers.getLimelightNTDouble(limelightName, "tx");
    }

    public static double getTY(String limelightName) {
        return LimelightHelpers.getLimelightNTDouble(limelightName, "ty");
    }

    public static double getTA(String limelightName) {
        return LimelightHelpers.getLimelightNTDouble(limelightName, "ta");
    }

    public static double[] getT2DArray(String limelightName) {
        return LimelightHelpers.getLimelightNTDoubleArray(limelightName, "t2d");
    }

    public static int getTargetCount(String limelightName) {
        double[] t2d = LimelightHelpers.getT2DArray(limelightName);
        if (t2d.length == 17) {
            return (int)t2d[1];
        }
        return 0;
    }

    public static int getClassifierClassIndex(String limelightName) {
        double[] t2d = LimelightHelpers.getT2DArray(limelightName);
        if (t2d.length == 17) {
            return (int)t2d[10];
        }
        return 0;
    }

    public static int getDetectorClassIndex(String limelightName) {
        double[] t2d = LimelightHelpers.getT2DArray(limelightName);
        if (t2d.length == 17) {
            return (int)t2d[11];
        }
        return 0;
    }

    public static String getClassifierClass(String limelightName) {
        return LimelightHelpers.getLimelightNTString(limelightName, "tcclass");
    }

    public static String getDetectorClass(String limelightName) {
        return LimelightHelpers.getLimelightNTString(limelightName, "tdclass");
    }

    public static double getLatency_Pipeline(String limelightName) {
        return LimelightHelpers.getLimelightNTDouble(limelightName, "tl");
    }

    public static double getLatency_Capture(String limelightName) {
        return LimelightHelpers.getLimelightNTDouble(limelightName, "cl");
    }

    public static double getCurrentPipelineIndex(String limelightName) {
        return LimelightHelpers.getLimelightNTDouble(limelightName, "getpipe");
    }

    public static String getCurrentPipelineType(String limelightName) {
        return LimelightHelpers.getLimelightNTString(limelightName, "getpipetype");
    }

    public static String getJSONDump(String limelightName) {
        return LimelightHelpers.getLimelightNTString(limelightName, "json");
    }

    @Deprecated
    public static double[] getBotpose(String limelightName) {
        return LimelightHelpers.getLimelightNTDoubleArray(limelightName, "botpose");
    }

    @Deprecated
    public static double[] getBotpose_wpiRed(String limelightName) {
        return LimelightHelpers.getLimelightNTDoubleArray(limelightName, "botpose_wpired");
    }

    @Deprecated
    public static double[] getBotpose_wpiBlue(String limelightName) {
        return LimelightHelpers.getLimelightNTDoubleArray(limelightName, "botpose_wpiblue");
    }

    public static double[] getBotPose(String limelightName) {
        return LimelightHelpers.getLimelightNTDoubleArray(limelightName, "botpose");
    }

    public static double[] getBotPose_wpiRed(String limelightName) {
        return LimelightHelpers.getLimelightNTDoubleArray(limelightName, "botpose_wpired");
    }

    public static double[] getBotPose_wpiBlue(String limelightName) {
        return LimelightHelpers.getLimelightNTDoubleArray(limelightName, "botpose_wpiblue");
    }

    public static double[] getBotPose_TargetSpace(String limelightName) {
        return LimelightHelpers.getLimelightNTDoubleArray(limelightName, "botpose_targetspace");
    }

    public static double[] getCameraPose_TargetSpace(String limelightName) {
        return LimelightHelpers.getLimelightNTDoubleArray(limelightName, "camerapose_targetspace");
    }

    public static double[] getTargetPose_CameraSpace(String limelightName) {
        return LimelightHelpers.getLimelightNTDoubleArray(limelightName, "targetpose_cameraspace");
    }

    public static double[] getTargetPose_RobotSpace(String limelightName) {
        return LimelightHelpers.getLimelightNTDoubleArray(limelightName, "targetpose_robotspace");
    }

    public static double[] getTargetColor(String limelightName) {
        return LimelightHelpers.getLimelightNTDoubleArray(limelightName, "tc");
    }

    public static double getFiducialID(String limelightName) {
        return LimelightHelpers.getLimelightNTDouble(limelightName, "tid");
    }

    public static String getNeuralClassID(String limelightName) {
        return LimelightHelpers.getLimelightNTString(limelightName, "tclass");
    }

    public static String[] getRawBarcodeData(String limelightName) {
        return LimelightHelpers.getLimelightNTStringArray(limelightName, "rawbarcodes");
    }

    public static Pose3d getBotPose3d(String limelightName) {
        double[] poseArray = LimelightHelpers.getLimelightNTDoubleArray(limelightName, "botpose");
        return LimelightHelpers.toPose3D(poseArray);
    }

    public static Pose3d getBotPose3d_wpiRed(String limelightName) {
        double[] poseArray = LimelightHelpers.getLimelightNTDoubleArray(limelightName, "botpose_wpired");
        return LimelightHelpers.toPose3D(poseArray);
    }

    public static Pose3d getBotPose3d_wpiBlue(String limelightName) {
        double[] poseArray = LimelightHelpers.getLimelightNTDoubleArray(limelightName, "botpose_wpiblue");
        return LimelightHelpers.toPose3D(poseArray);
    }

    public static Pose3d getBotPose3d_TargetSpace(String limelightName) {
        double[] poseArray = LimelightHelpers.getLimelightNTDoubleArray(limelightName, "botpose_targetspace");
        return LimelightHelpers.toPose3D(poseArray);
    }

    public static Pose3d getCameraPose3d_TargetSpace(String limelightName) {
        double[] poseArray = LimelightHelpers.getLimelightNTDoubleArray(limelightName, "camerapose_targetspace");
        return LimelightHelpers.toPose3D(poseArray);
    }

    public static Pose3d getTargetPose3d_CameraSpace(String limelightName) {
        double[] poseArray = LimelightHelpers.getLimelightNTDoubleArray(limelightName, "targetpose_cameraspace");
        return LimelightHelpers.toPose3D(poseArray);
    }

    public static Pose3d getTargetPose3d_RobotSpace(String limelightName) {
        double[] poseArray = LimelightHelpers.getLimelightNTDoubleArray(limelightName, "targetpose_robotspace");
        return LimelightHelpers.toPose3D(poseArray);
    }

    public static Pose3d getCameraPose3d_RobotSpace(String limelightName) {
        double[] poseArray = LimelightHelpers.getLimelightNTDoubleArray(limelightName, "camerapose_robotspace");
        return LimelightHelpers.toPose3D(poseArray);
    }

    public static Pose2d getBotPose2d_wpiBlue(String limelightName) {
        double[] result = LimelightHelpers.getBotPose_wpiBlue(limelightName);
        return LimelightHelpers.toPose2D(result);
    }

    public static PoseEstimate getBotPoseEstimate_wpiBlue(String limelightName) {
        return LimelightHelpers.getBotPoseEstimate(limelightName, "botpose_wpiblue");
    }

    public static PoseEstimate getBotPoseEstimate_wpiBlue_MegaTag2(String limelightName) {
        return LimelightHelpers.getBotPoseEstimate(limelightName, "botpose_orb_wpiblue");
    }

    public static Pose2d getBotPose2d_wpiRed(String limelightName) {
        double[] result = LimelightHelpers.getBotPose_wpiRed(limelightName);
        return LimelightHelpers.toPose2D(result);
    }

    public static PoseEstimate getBotPoseEstimate_wpiRed(String limelightName) {
        return LimelightHelpers.getBotPoseEstimate(limelightName, "botpose_wpired");
    }

    public static PoseEstimate getBotPoseEstimate_wpiRed_MegaTag2(String limelightName) {
        return LimelightHelpers.getBotPoseEstimate(limelightName, "botpose_orb_wpired");
    }

    public static Pose2d getBotPose2d(String limelightName) {
        double[] result = LimelightHelpers.getBotPose(limelightName);
        return LimelightHelpers.toPose2D(result);
    }

    public static boolean getTV(String limelightName) {
        return 1.0 == LimelightHelpers.getLimelightNTDouble(limelightName, "tv");
    }

    public static void setPipelineIndex(String limelightName, int pipelineIndex) {
        LimelightHelpers.setLimelightNTDouble(limelightName, "pipeline", pipelineIndex);
    }

    public static void setPriorityTagID(String limelightName, int ID) {
        LimelightHelpers.setLimelightNTDouble(limelightName, "priorityid", ID);
    }

    public static void setLEDMode_PipelineControl(String limelightName) {
        LimelightHelpers.setLimelightNTDouble(limelightName, "ledMode", 0.0);
    }

    public static void setLEDMode_ForceOff(String limelightName) {
        LimelightHelpers.setLimelightNTDouble(limelightName, "ledMode", 1.0);
    }

    public static void setLEDMode_ForceBlink(String limelightName) {
        LimelightHelpers.setLimelightNTDouble(limelightName, "ledMode", 2.0);
    }

    public static void setLEDMode_ForceOn(String limelightName) {
        LimelightHelpers.setLimelightNTDouble(limelightName, "ledMode", 3.0);
    }

    public static void setStreamMode_Standard(String limelightName) {
        LimelightHelpers.setLimelightNTDouble(limelightName, "stream", 0.0);
    }

    public static void setStreamMode_PiPMain(String limelightName) {
        LimelightHelpers.setLimelightNTDouble(limelightName, "stream", 1.0);
    }

    public static void setStreamMode_PiPSecondary(String limelightName) {
        LimelightHelpers.setLimelightNTDouble(limelightName, "stream", 2.0);
    }

    public static void setCropWindow(String limelightName, double cropXMin, double cropXMax, double cropYMin, double cropYMax) {
        double[] entries = new double[]{cropXMin, cropXMax, cropYMin, cropYMax};
        LimelightHelpers.setLimelightNTDoubleArray(limelightName, "crop", entries);
    }

    public static void setFiducial3DOffset(String limelightName, double offsetX, double offsetY, double offsetZ) {
        double[] entries = new double[]{offsetX, offsetY, offsetZ};
        LimelightHelpers.setLimelightNTDoubleArray(limelightName, "fiducial_offset_set", entries);
    }

    public static void SetRobotOrientation(String limelightName, double yaw, double yawRate, double pitch, double pitchRate, double roll, double rollRate) {
        LimelightHelpers.SetRobotOrientation_INTERNAL(limelightName, yaw, yawRate, pitch, pitchRate, roll, rollRate, true);
    }

    public static void SetRobotOrientation_NoFlush(String limelightName, double yaw, double yawRate, double pitch, double pitchRate, double roll, double rollRate) {
        LimelightHelpers.SetRobotOrientation_INTERNAL(limelightName, yaw, yawRate, pitch, pitchRate, roll, rollRate, false);
    }

    private static void SetRobotOrientation_INTERNAL(String limelightName, double yaw, double yawRate, double pitch, double pitchRate, double roll, double rollRate, boolean flush) {
        double[] entries = new double[]{yaw, yawRate, pitch, pitchRate, roll, rollRate};
        LimelightHelpers.setLimelightNTDoubleArray(limelightName, "robot_orientation_set", entries);
        if (flush) {
            LimelightHelpers.Flush();
        }
    }

    public static void SetFidcuial3DOffset(String limelightName, double x, double y, double z) {
        double[] entries = new double[]{x, y, z};
        LimelightHelpers.setLimelightNTDoubleArray(limelightName, "fiducial_offset_set", entries);
    }

    public static void SetFiducialIDFiltersOverride(String limelightName, int[] validIDs) {
        double[] validIDsDouble = new double[validIDs.length];
        for (int i = 0; i < validIDs.length; ++i) {
            validIDsDouble[i] = validIDs[i];
        }
        LimelightHelpers.setLimelightNTDoubleArray(limelightName, "fiducial_id_filters_set", validIDsDouble);
    }

    public static void SetFiducialDownscalingOverride(String limelightName, float downscale) {
        int d = 0;
        if ((double)downscale == 1.0) {
            d = 1;
        }
        if ((double)downscale == 1.5) {
            d = 2;
        }
        if (downscale == 2.0f) {
            d = 3;
        }
        if (downscale == 3.0f) {
            d = 4;
        }
        if (downscale == 4.0f) {
            d = 5;
        }
        LimelightHelpers.setLimelightNTDouble(limelightName, "fiducial_downscale_set", d);
    }

    public static void setCameraPose_RobotSpace(String limelightName, double forward, double side, double up, double roll, double pitch, double yaw) {
        double[] entries = new double[]{forward, side, up, roll, pitch, yaw};
        LimelightHelpers.setLimelightNTDoubleArray(limelightName, "camerapose_robotspace_set", entries);
    }

    public static void setPythonScriptData(String limelightName, double[] outgoingPythonData) {
        LimelightHelpers.setLimelightNTDoubleArray(limelightName, "llrobot", outgoingPythonData);
    }

    public static double[] getPythonScriptData(String limelightName) {
        return LimelightHelpers.getLimelightNTDoubleArray(limelightName, "llpython");
    }

    public static CompletableFuture<Boolean> takeSnapshot(String tableName, String snapshotName) {
        return CompletableFuture.supplyAsync(() -> LimelightHelpers.SYNCH_TAKESNAPSHOT(tableName, snapshotName));
    }

    private static boolean SYNCH_TAKESNAPSHOT(String tableName, String snapshotName) {
        URL url = LimelightHelpers.getLimelightURLString(tableName, "capturesnapshot");
        try {
            int responseCode;
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            if (snapshotName != null && snapshotName != "") {
                connection.setRequestProperty("snapname", snapshotName);
            }
            if ((responseCode = connection.getResponseCode()) == 200) {
                return true;
            }
            System.err.println("Bad LL Request");
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        return false;
    }

    public static LimelightResults getLatestResults(String limelightName) {
        double millis;
        long start = System.nanoTime();
        LimelightResults results = new LimelightResults();
        if (mapper == null) {
            mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        try {
            results = (LimelightResults)mapper.readValue(LimelightHelpers.getJSONDump(limelightName), LimelightResults.class);
        }
        catch (JsonProcessingException e) {
            results.error = "lljson error: " + e.getMessage();
        }
        long end = System.nanoTime();
        results.latency_jsonParse = millis = (double)(end - start) * 1.0E-6;
        if (profileJSON) {
            System.out.printf("lljson: %.2f\r\n", millis);
        }
        return results;
    }

    static {
        profileJSON = false;
    }

    public static class RawFiducial {
        public int id = 0;
        public double txnc = 0.0;
        public double tync = 0.0;
        public double ta = 0.0;
        public double distToCamera = 0.0;
        public double distToRobot = 0.0;
        public double ambiguity = 0.0;

        public RawFiducial(int id, double txnc, double tync, double ta, double distToCamera, double distToRobot, double ambiguity) {
            this.id = id;
            this.txnc = txnc;
            this.tync = tync;
            this.ta = ta;
            this.distToCamera = distToCamera;
            this.distToRobot = distToRobot;
            this.ambiguity = ambiguity;
        }
    }

    public static class PoseEstimate {
        public Pose2d pose;
        public double timestampSeconds;
        public double latency;
        public int tagCount;
        public double tagSpan;
        public double avgTagDist;
        public double avgTagArea;
        public RawFiducial[] rawFiducials;

        public PoseEstimate() {
            this.pose = new Pose2d();
            this.timestampSeconds = 0.0;
            this.latency = 0.0;
            this.tagCount = 0;
            this.tagSpan = 0.0;
            this.avgTagDist = 0.0;
            this.avgTagArea = 0.0;
            this.rawFiducials = new RawFiducial[0];
        }

        public PoseEstimate(Pose2d pose, double timestampSeconds, double latency, int tagCount, double tagSpan, double avgTagDist, double avgTagArea, RawFiducial[] rawFiducials) {
            this.pose = pose;
            this.timestampSeconds = timestampSeconds;
            this.latency = latency;
            this.tagCount = tagCount;
            this.tagSpan = tagSpan;
            this.avgTagDist = avgTagDist;
            this.avgTagArea = avgTagArea;
            this.rawFiducials = rawFiducials;
        }
    }

    public static class RawDetection {
        public int classId = 0;
        public double txnc = 0.0;
        public double tync = 0.0;
        public double ta = 0.0;
        public double corner0_X = 0.0;
        public double corner0_Y = 0.0;
        public double corner1_X = 0.0;
        public double corner1_Y = 0.0;
        public double corner2_X = 0.0;
        public double corner2_Y = 0.0;
        public double corner3_X = 0.0;
        public double corner3_Y = 0.0;

        public RawDetection(int classId, double txnc, double tync, double ta, double corner0_X, double corner0_Y, double corner1_X, double corner1_Y, double corner2_X, double corner2_Y, double corner3_X, double corner3_Y) {
            this.classId = classId;
            this.txnc = txnc;
            this.tync = tync;
            this.ta = ta;
            this.corner0_X = corner0_X;
            this.corner0_Y = corner0_Y;
            this.corner1_X = corner1_X;
            this.corner1_Y = corner1_Y;
            this.corner2_X = corner2_X;
            this.corner2_Y = corner2_Y;
            this.corner3_X = corner3_X;
            this.corner3_Y = corner3_Y;
        }
    }

    public static class LimelightResults {
        public String error;
        @JsonProperty(value="pID")
        public double pipelineID;
        @JsonProperty(value="tl")
        public double latency_pipeline;
        @JsonProperty(value="cl")
        public double latency_capture;
        public double latency_jsonParse;
        @JsonProperty(value="ts")
        public double timestamp_LIMELIGHT_publish;
        @JsonProperty(value="ts_rio")
        public double timestamp_RIOFPGA_capture;
        @JsonProperty(value="v")
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        public boolean valid;
        @JsonProperty(value="botpose")
        public double[] botpose = new double[6];
        @JsonProperty(value="botpose_wpired")
        public double[] botpose_wpired = new double[6];
        @JsonProperty(value="botpose_wpiblue")
        public double[] botpose_wpiblue = new double[6];
        @JsonProperty(value="botpose_tagcount")
        public double botpose_tagcount;
        @JsonProperty(value="botpose_span")
        public double botpose_span;
        @JsonProperty(value="botpose_avgdist")
        public double botpose_avgdist;
        @JsonProperty(value="botpose_avgarea")
        public double botpose_avgarea;
        @JsonProperty(value="t6c_rs")
        public double[] camerapose_robotspace = new double[6];
        @JsonProperty(value="Retro")
        public LimelightTarget_Retro[] targets_Retro = new LimelightTarget_Retro[0];
        @JsonProperty(value="Fiducial")
        public LimelightTarget_Fiducial[] targets_Fiducials = new LimelightTarget_Fiducial[0];
        @JsonProperty(value="Classifier")
        public LimelightTarget_Classifier[] targets_Classifier = new LimelightTarget_Classifier[0];
        @JsonProperty(value="Detector")
        public LimelightTarget_Detector[] targets_Detector = new LimelightTarget_Detector[0];
        @JsonProperty(value="Barcode")
        public LimelightTarget_Barcode[] targets_Barcode = new LimelightTarget_Barcode[0];

        public Pose3d getBotPose3d() {
            return LimelightHelpers.toPose3D(this.botpose);
        }

        public Pose3d getBotPose3d_wpiRed() {
            return LimelightHelpers.toPose3D(this.botpose_wpired);
        }

        public Pose3d getBotPose3d_wpiBlue() {
            return LimelightHelpers.toPose3D(this.botpose_wpiblue);
        }

        public Pose2d getBotPose2d() {
            return LimelightHelpers.toPose2D(this.botpose);
        }

        public Pose2d getBotPose2d_wpiRed() {
            return LimelightHelpers.toPose2D(this.botpose_wpired);
        }

        public Pose2d getBotPose2d_wpiBlue() {
            return LimelightHelpers.toPose2D(this.botpose_wpiblue);
        }
    }

    public static class LimelightTarget_Detector {
        @JsonProperty(value="class")
        public String className;
        @JsonProperty(value="classID")
        public double classID;
        @JsonProperty(value="conf")
        public double confidence;
        @JsonProperty(value="ta")
        public double ta;
        @JsonProperty(value="tx")
        public double tx;
        @JsonProperty(value="txp")
        public double tx_pixels;
        @JsonProperty(value="ty")
        public double ty;
        @JsonProperty(value="typ")
        public double ty_pixels;
    }

    public static class LimelightTarget_Classifier {
        @JsonProperty(value="class")
        public String className;
        @JsonProperty(value="classID")
        public double classID;
        @JsonProperty(value="conf")
        public double confidence;
        @JsonProperty(value="zone")
        public double zone;
        @JsonProperty(value="tx")
        public double tx;
        @JsonProperty(value="txp")
        public double tx_pixels;
        @JsonProperty(value="ty")
        public double ty;
        @JsonProperty(value="typ")
        public double ty_pixels;
    }

    public static class LimelightTarget_Barcode {
    }

    public static class LimelightTarget_Fiducial {
        @JsonProperty(value="fID")
        public double fiducialID;
        @JsonProperty(value="fam")
        public String fiducialFamily;
        @JsonProperty(value="t6c_ts")
        private double[] cameraPose_TargetSpace = new double[6];
        @JsonProperty(value="t6r_fs")
        private double[] robotPose_FieldSpace = new double[6];
        @JsonProperty(value="t6r_ts")
        private double[] robotPose_TargetSpace = new double[6];
        @JsonProperty(value="t6t_cs")
        private double[] targetPose_CameraSpace = new double[6];
        @JsonProperty(value="t6t_rs")
        private double[] targetPose_RobotSpace = new double[6];
        @JsonProperty(value="ta")
        public double ta;
        @JsonProperty(value="tx")
        public double tx;
        @JsonProperty(value="txp")
        public double tx_pixels;
        @JsonProperty(value="ty")
        public double ty;
        @JsonProperty(value="typ")
        public double ty_pixels;
        @JsonProperty(value="ts")
        public double ts;

        public Pose3d getCameraPose_TargetSpace() {
            return LimelightHelpers.toPose3D(this.cameraPose_TargetSpace);
        }

        public Pose3d getRobotPose_FieldSpace() {
            return LimelightHelpers.toPose3D(this.robotPose_FieldSpace);
        }

        public Pose3d getRobotPose_TargetSpace() {
            return LimelightHelpers.toPose3D(this.robotPose_TargetSpace);
        }

        public Pose3d getTargetPose_CameraSpace() {
            return LimelightHelpers.toPose3D(this.targetPose_CameraSpace);
        }

        public Pose3d getTargetPose_RobotSpace() {
            return LimelightHelpers.toPose3D(this.targetPose_RobotSpace);
        }

        public Pose2d getCameraPose_TargetSpace2D() {
            return LimelightHelpers.toPose2D(this.cameraPose_TargetSpace);
        }

        public Pose2d getRobotPose_FieldSpace2D() {
            return LimelightHelpers.toPose2D(this.robotPose_FieldSpace);
        }

        public Pose2d getRobotPose_TargetSpace2D() {
            return LimelightHelpers.toPose2D(this.robotPose_TargetSpace);
        }

        public Pose2d getTargetPose_CameraSpace2D() {
            return LimelightHelpers.toPose2D(this.targetPose_CameraSpace);
        }

        public Pose2d getTargetPose_RobotSpace2D() {
            return LimelightHelpers.toPose2D(this.targetPose_RobotSpace);
        }
    }

    public static class LimelightTarget_Retro {
        @JsonProperty(value="t6c_ts")
        private double[] cameraPose_TargetSpace = new double[6];
        @JsonProperty(value="t6r_fs")
        private double[] robotPose_FieldSpace = new double[6];
        @JsonProperty(value="t6r_ts")
        private double[] robotPose_TargetSpace = new double[6];
        @JsonProperty(value="t6t_cs")
        private double[] targetPose_CameraSpace = new double[6];
        @JsonProperty(value="t6t_rs")
        private double[] targetPose_RobotSpace = new double[6];
        @JsonProperty(value="ta")
        public double ta;
        @JsonProperty(value="tx")
        public double tx;
        @JsonProperty(value="txp")
        public double tx_pixels;
        @JsonProperty(value="ty")
        public double ty;
        @JsonProperty(value="typ")
        public double ty_pixels;
        @JsonProperty(value="ts")
        public double ts;

        public Pose3d getCameraPose_TargetSpace() {
            return LimelightHelpers.toPose3D(this.cameraPose_TargetSpace);
        }

        public Pose3d getRobotPose_FieldSpace() {
            return LimelightHelpers.toPose3D(this.robotPose_FieldSpace);
        }

        public Pose3d getRobotPose_TargetSpace() {
            return LimelightHelpers.toPose3D(this.robotPose_TargetSpace);
        }

        public Pose3d getTargetPose_CameraSpace() {
            return LimelightHelpers.toPose3D(this.targetPose_CameraSpace);
        }

        public Pose3d getTargetPose_RobotSpace() {
            return LimelightHelpers.toPose3D(this.targetPose_RobotSpace);
        }

        public Pose2d getCameraPose_TargetSpace2D() {
            return LimelightHelpers.toPose2D(this.cameraPose_TargetSpace);
        }

        public Pose2d getRobotPose_FieldSpace2D() {
            return LimelightHelpers.toPose2D(this.robotPose_FieldSpace);
        }

        public Pose2d getRobotPose_TargetSpace2D() {
            return LimelightHelpers.toPose2D(this.robotPose_TargetSpace);
        }

        public Pose2d getTargetPose_CameraSpace2D() {
            return LimelightHelpers.toPose2D(this.targetPose_CameraSpace);
        }

        public Pose2d getTargetPose_RobotSpace2D() {
            return LimelightHelpers.toPose2D(this.targetPose_RobotSpace);
        }
    }
}

