/*
 * Decompiled with CFR 0.152.
 */
package com.frcteam3255.utils;

import com.frcteam3255.utils.SN_Point2D;

public class SN_Lerp {
    private double m_maxInput = Double.NEGATIVE_INFINITY;
    private double m_minInput = Double.POSITIVE_INFINITY;
    private final SN_Point2D[] m_points;
    public final int size;

    public SN_Lerp(SN_Point2D ... points) {
        this.m_points = points;
        this.size = this.m_points.length;
        for (int i = 0; i < this.size; ++i) {
            if (this.m_points[i].getX() > this.m_maxInput) {
                this.m_maxInput = this.m_points[i].getX();
            }
            if (!(this.m_points[i].getX() < this.m_minInput)) continue;
            this.m_minInput = this.m_points[i].getX();
        }
    }

    public double getOutput(double input) {
        int index = 0;
        if (input <= this.m_minInput) {
            index = 0;
        } else if (input >= this.m_maxInput) {
            index = this.size - 2;
        } else {
            for (int i = 1; i < this.m_points.length; ++i) {
                if (!(input > this.m_points[i - 1].getX()) || !(input <= this.m_points[i].getX())) continue;
                index = i - 1;
            }
        }
        return SN_Lerp.interpolate(input, this.m_points[index], this.m_points[index + 1]);
    }

    public static double interpolate(double input, SN_Point2D point1, SN_Point2D point2) {
        double slope = (point2.getY() - point1.getY()) / (point2.getX() - point1.getX());
        double delta_x = input - point1.getX();
        double delta_y = delta_x * slope;
        return point1.getY() + delta_y;
    }

    public double[] getX() {
        double[] xVals = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            xVals[i] = this.m_points[i].getX();
        }
        return xVals;
    }

    public double[] getY() {
        double[] yVals = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            yVals[i] = this.m_points[i].getY();
        }
        return yVals;
    }

    public SN_Point2D[] getTable() {
        return this.m_points;
    }
}

