/*
 * Decompiled with CFR 0.152.
 */
package com.frcteam3255.utils;

public class SN_Math {
    public static final int TALONFX_ENCODER_PULSES_PER_COUNT = 2048;
    public static final int QUAD_ENCODER_PULSES_PER_COUNT = 4096;

    public static double interpolate(double input, double minInput, double maxInput, double outputAtMin, double outputAtMax) {
        double output = input;
        output = input <= minInput ? outputAtMin : (input >= maxInput ? outputAtMax : outputAtMin + (input - minInput) / (maxInput - minInput) * (outputAtMax - outputAtMin));
        return output;
    }

    public static double signedPow(double base, double exponent) {
        double result = Math.pow(base, exponent);
        return base > 0.0 ? result : -result;
    }

    public static double velocityToRPM(double a_velocity, int a_pulsesPerCount) {
        try {
            double rpm = a_velocity;
            rpm *= 10.0;
            rpm *= 60.0;
            return rpm /= (double)a_pulsesPerCount;
        }
        catch (ArithmeticException e) {
            System.err.println("pulsesPerCount can not be 0");
            throw e;
        }
    }

    public static double RPMToVelocity(double a_rpm, int a_pulsesPerCount) {
        double velocity = a_rpm;
        velocity *= (double)a_pulsesPerCount;
        velocity /= 60.0;
        return velocity /= 10.0;
    }

    public static double falconToDegrees(double counts, double gearRatio) {
        return counts * (360.0 / (gearRatio * 2048.0));
    }

    public static double degreesToFalcon(double degrees, double gearRatio) {
        double ticks = degrees / (360.0 / (gearRatio * 2048.0));
        return ticks;
    }

    public static double falconToRPM(double velocityCounts, double gearRatio) {
        double motorRPM = velocityCounts * 0.29296875;
        double mechRPM = motorRPM / gearRatio;
        return mechRPM;
    }

    public static double RPMToFalcon(double RPM, double gearRatio) {
        double motorRPM = RPM * gearRatio;
        double sensorCounts = motorRPM * 3.4133333333333336;
        return sensorCounts;
    }

    public static double falconToMPS(double velocitycounts, double circumference, double gearRatio) {
        double wheelRPM = SN_Math.falconToRPM(velocitycounts, gearRatio);
        double wheelMPS = wheelRPM * circumference / 60.0;
        return wheelMPS;
    }

    public static double MPSToFalcon(double velocity, double circumference, double gearRatio) {
        double wheelRPM = velocity * 60.0 / circumference;
        double wheelVelocity = SN_Math.RPMToFalcon(wheelRPM, gearRatio);
        return wheelVelocity;
    }

    public static double falconToMeters(double position, double circumference, double gearRatio) {
        double motorRotations = position / 2048.0;
        double wheelRotations = motorRotations / gearRatio;
        double meters = wheelRotations * circumference;
        return meters;
    }

    public static double metersToFalcon(double meters, double circumference, double gearRatio) {
        double wheelRotations = meters / circumference;
        double motorRotations = wheelRotations * gearRatio;
        double encoderCounts = motorRotations * 2048.0;
        return encoderCounts;
    }

    public static double rotationsToMeters(double rotations, double circumference, double gearRatio) {
        double wheelRPS = rotations / gearRatio;
        double wheelMPS = wheelRPS * circumference;
        return wheelMPS;
    }

    public static double metersToRotations(double meters, double circumference, double gearRatio) {
        double wheelRotations = meters / circumference;
        double motorRotations = wheelRotations * gearRatio;
        return motorRotations;
    }
}

