/*
 * Decompiled with CFR 0.152.
 */
package com.frcteam3255.utils;

import com.ctre.phoenix.motion.BufferedTrajectoryPointStream;
import com.ctre.phoenix.motion.TrajectoryPoint;
import edu.wpi.first.wpilibj.Filesystem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;

public class SN_MotionProfile {
    public BufferedTrajectoryPointStream pointsLeft = new BufferedTrajectoryPointStream();
    public BufferedTrajectoryPointStream pointsRight = new BufferedTrajectoryPointStream();
    String leftFilename;
    String rightFilename;
    static double sensorUnitsPerTick = 600.0;

    public SN_MotionProfile(String a_leftName, String a_rightName) {
        this.leftFilename = a_leftName;
        this.rightFilename = a_rightName;
        this.reload();
    }

    public void reload() {
        try {
            SN_MotionProfile.initBuffer(this.pointsLeft, SN_MotionProfile.reader(this.leftFilename), SN_MotionProfile.count(this.leftFilename));
        }
        catch (IOException e) {
            System.out.println("initBuffer failed :(. Is your file in deploy?");
            e.printStackTrace();
        }
        try {
            SN_MotionProfile.initBuffer(this.pointsRight, SN_MotionProfile.reader(this.rightFilename), SN_MotionProfile.count(this.rightFilename));
        }
        catch (IOException e) {
            System.out.println("initBuffer failed :(. Is your file in deploy?");
            e.printStackTrace();
        }
    }

    public static void setSensorUnitsPerTick(double a_sensorUnitsPerTick) {
        sensorUnitsPerTick = a_sensorUnitsPerTick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int count(String filename) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(Filesystem.getDeployDirectory() + "/paths/" + filename));){
            byte[] c = new byte[1024];
            int count = 0;
            int readChars = 0;
            boolean empty = true;
            while ((readChars = ((InputStream)is).read(c)) != -1) {
                empty = false;
                for (int i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
            }
            int n = count == 0 && !empty ? 1 : count;
            return n;
        }
    }

    public static void initBuffer(BufferedTrajectoryPointStream bufferedStream, double[][] profile, int totalCnt) {
        boolean forward = true;
        TrajectoryPoint point = new TrajectoryPoint();
        bufferedStream.Clear();
        for (int i = 0; i < totalCnt; ++i) {
            int durationMilliseconds;
            double direction = 1.0;
            double positionRot = profile[i][0];
            double velocityRPM = profile[i][1];
            point.timeDur = durationMilliseconds = (int)profile[i][2];
            point.position = 1.0 * positionRot * sensorUnitsPerTick;
            point.velocity = 1.0 * velocityRPM * sensorUnitsPerTick / 600.0;
            point.arbFeedFwd = 0.0;
            point.profileSlotSelect0 = 0;
            point.zeroPos = false;
            point.isLastPoint = i + 1 == totalCnt;
            point.useAuxPID = false;
            bufferedStream.Write(point);
        }
    }

    public static double[][] reader(String fileName) throws IOException {
        File toScan = new File(Filesystem.getDeployDirectory() + "/paths", fileName);
        Scanner scanner = new Scanner(toScan);
        double[][] output = new double[SN_MotionProfile.count(fileName) + 1][3];
        int i = 0;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (!line.contains("Position")) {
                String[] fields;
                int j = 0;
                for (String field : fields = line.split(",")) {
                    if (j < 3) {
                        output[i][j] = fileName.contains("neg") && (j == 0 || j == 1) ? Double.parseDouble(field.replaceAll("\\s+", "")) : -Double.parseDouble(field.replaceAll("\\s+", ""));
                    }
                    ++j;
                }
                ++i;
                continue;
            }
            output = new double[SN_MotionProfile.count(fileName) - 1][3];
        }
        scanner.close();
        return output;
    }
}

